#include <windows.h>
#include <psapi.h>
#include <stdio.h>

bool CheckProcessName (DWORD Pid) {
    CHAR ProcName[MAX_PATH] = "<unknown>";

    HANDLE hProc = OpenProcess (PROCESS_QUERY_INFORMATION|PROCESS_VM_READ, FALSE, Pid);

    if ( NULL != hProc ) {
        HMODULE hMod;
        DWORD cnt;

		if ( EnumProcessModules (hProc, &hMod, sizeof(hMod), &cnt) ) {
            GetModuleBaseName (hProc, hMod, ProcName, sizeof(ProcName));
        }
    }

    printf ("%s  (PID: %u)\n", ProcName, Pid);

    CloseHandle (hProc);

	return !_stricmp (ProcName, "ollydbg.exe");
}

void main () {
    DWORD Procs[256], Cnt;
    unsigned int i;

    if ( !EnumProcesses (Procs, sizeof(Procs), &Cnt) )
        return;

    for ( i=0; i<Cnt/sizeof(DWORD); i++ )
		if( Procs[i] != 0 ) {
            if ( CheckProcessName (Procs[i]) )
				break;
		}

	if ( i==Cnt/sizeof(DWORD) )
		MessageBox (0, "Hello World!!!", "antidebug_1", MB_OK);
	else 
		MessageBox (0, "OllyDbg.exe!!!", "antidebug_1", MB_OK);
}
